﻿var panelMenu = {
    context: $("#main-header"),
    getPanelId: function () {
        return $("#survey-block", panelMenu.context).attr("data-panelId");
    },
    parsePanel: function () {
        if ($("#panel-data", panelMenu.context).length > 0)
            panelMenu.panel = JSON.parse($("#panel-data", panelMenu.context).val());
    },
    panel: undefined,
    panels: [],
    bindEvents: function () {
        var panelId = panelMenu.getPanelId();

        panelMenu.context.on("click", ".v-editPanel", function () {
            var panelId = panelMenu.getPanelId();
            modalDialog.showWindow(a4.getAction("Edit", "Home", "Panel", { id: panelId }), 500, 700, { afterClose: function () { panelMenu.refresh(); } });
        });

        panelMenu.context.on("click", ".h-panelSelector", function () {
            if (panelMenu.panels.length == 0) {
                a4.callServerMethod(a4.getAction("GetPanelsForAutoComplete", "Home", "Panel"), {}, function (result) {
                    panelMenu.panels = result;
                    panelMenu.renderPanelSelector(panelMenu.panels);
                });
            }
        });

        panelMenu.context.on("keyup", ".h-panelSelector .h-search", function (e) {
            panelMenu.searchPanels($(this).val());
            return e.keyCode != 13;
        });
    },
    onBeforeRefresh: undefined,
    onAfterRefresh: undefined,
    refresh: function () {
        if (typeof panelMenu.onBeforeRefresh === "function")
            panelMenu.onBeforeRefresh();

        var controller = $("#survey-block", panelMenu.context).attr("data-controller");
        var action = $("#survey-block", panelMenu.context).attr("data-action");
        var panelId = panelMenu.getPanelId();

        a4.callServerMethod(a4.getAction("GetMainHeader", "Shared", "Panel"), { currentController: controller, currentAction: action, panelId: panelId },
            function (result) {
                if (result) {
                    $("#survey-block", panelMenu.context).replaceWith(result);
                    panelMenu.parsePanel();
                }
            },
            function (error) { }
        );

        if (typeof panelMenu.onAfterRefresh === "function")
            panelMenu.onAfterRefresh();
    },
    searchPanels: function (value) {
        var matcher = new RegExp($.ui.autocomplete.escapeRegex(value), "i");

        panelMenu.renderPanelSelector(_.filter(panelMenu.panels, function (p) { return matcher.test(p.Label) }));
    },
    renderPanelSelector: function (panels) {
        var dropDown = $(".h-panelSelector .dropdown-menu ul", panelMenu.context);
        var controller = $("#survey-block", panelMenu.context).attr("data-controller");
        var action = $("#survey-block", panelMenu.context).attr("data-action");

        $("li", dropDown).remove();

        _.each(panels, function (s) {
            dropDown.append($("<li />").append($("<a />", { "href": a4.getAction(action, controller, "Panel", { id: s.Value }) }).append(s.Label)));
        });

        dropDown.mCustomScrollbar("destroy");
        dropDown.mCustomScrollbar({ theme: "light-2", scrollInertia: 0 });
    }
}

$(document).ready(function () {
    panelMenu.bindEvents();
    panelMenu.parsePanel();
});